/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.preview.internal;

import com.aptana.core.IURIMapper;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.preview.IPreviewHandler;
import com.aptana.preview.PreviewConfig;
import com.aptana.preview.SourceConfig;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.core.WorkspaceResolvingURIMapper;
import java.net.MalformedURLException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;

public final class DefaultPreviewHandler
implements IPreviewHandler {
    private static DefaultPreviewHandler instance;
    private IContentType contentTypeHTML = Platform.getContentTypeManager().findContentTypeFor("index.html");

    private DefaultPreviewHandler() {
    }

    public static synchronized DefaultPreviewHandler getInstance() {
        if (instance == null) {
            instance = new DefaultPreviewHandler();
        }
        return instance;
    }

    public PreviewConfig handle(SourceConfig config) throws CoreException {
        if (this.contentTypeHTML != null && this.contentTypeHTML.isAssociatedWith(config.getLocation().lastSegment())) {
            URI uri;
            IPath location;
            block8: {
                try {
                    location = config.getLocation();
                    uri = null;
                    if (config.getProject() != null) {
                        IStatus result;
                        IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
                        IServer server = WebServerCorePlugin.getDefault().getBuiltinWebServer();
                        if (server.getState() != IServer.State.STARTED && server.getState() != IServer.State.STARTING && !(result = server.start("run", (IProgressMonitor)new NullProgressMonitor())).isOK()) {
                            throw new CoreException(result);
                        }
                        uri = new WorkspaceResolvingURIMapper((IURIMapper)server).resolve(EFSUtils.getFileStore((IResource)resource));
                        if (uri == null) {
                            location = resource.getLocation();
                        }
                    }
                    if (config.getContent() == null) break block8;
                    return null;
                }
                catch (MalformedURLException e) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.preview", "", (Throwable)e));
                }
            }
            if (uri == null) {
                uri = location.toFile().toURI();
            }
            return new PreviewConfig(uri.toURL());
        }
        return null;
    }
}

